/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * Scene consts.
 * 
 * @ignore
 */

var CONST = {

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PENDING
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    PENDING: 0,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.INIT
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    INIT: 1,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.START
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    START: 2,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.LOADING
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    LOADING: 3,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.CREATING
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    CREATING: 4,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.RUNNING
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    RUNNING: 5,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PAUSED
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    PAUSED: 6,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SLEEPING
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    SLEEPING: 7,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SHUTDOWN
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    SHUTDOWN: 8,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.DESTROYED
     * @readOnly
     * @type {integer}
     * @since 3.0.0
     */
    DESTROYED: 9

};

module.exports = CONST;
